"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaypalService = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
let PaypalService = class PaypalService {
    configService;
    clientId;
    clientSecret;
    baseUrl;
    constructor(configService) {
        this.configService = configService;
        const clientId = this.configService.get('PAYPAL_CLIENT_ID');
        const clientSecret = this.configService.get('PAYPAL_CLIENT_SECRET');
        this.baseUrl = this.configService.get('PAYPAL_BASE_URL') || 'https://api-m.sandbox.paypal.com';
        if (!clientId || !clientSecret) {
            throw new Error('PayPal credentials are not defined in environment variables');
        }
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }
    async getAccessToken() {
        const auth = Buffer.from(`${this.clientId}:${this.clientSecret}`).toString('base64');
        const response = await fetch(`${this.baseUrl}/v1/oauth2/token`, {
            method: 'POST',
            headers: {
                'Authorization': `Basic ${auth}`,
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: 'grant_type=client_credentials',
        });
        const data = await response.json();
        if (!response.ok) {
            throw new common_1.BadRequestException(`PayPal auth error: ${data.error_description}`);
        }
        return data.access_token;
    }
    async createOrder(amount, currency = 'USD') {
        try {
            const accessToken = await this.getAccessToken();
            const response = await fetch(`${this.baseUrl}/v2/checkout/orders`, {
                method: 'POST',
                headers: {
                    'Authorization': `Bearer ${accessToken}`,
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    intent: 'CAPTURE',
                    purchase_units: [
                        {
                            amount: {
                                currency_code: currency,
                                value: amount.toString(),
                            },
                        },
                    ],
                }),
            });
            const data = await response.json();
            if (!response.ok) {
                throw new common_1.BadRequestException(`PayPal error: ${data.message}`);
            }
            return data;
        }
        catch (error) {
            throw new common_1.BadRequestException(`Failed to create PayPal order: ${error.message}`);
        }
    }
    async captureOrder(orderId) {
        try {
            const accessToken = await this.getAccessToken();
            const response = await fetch(`${this.baseUrl}/v2/checkout/orders/${orderId}/capture`, {
                method: 'POST',
                headers: {
                    'Authorization': `Bearer ${accessToken}`,
                    'Content-Type': 'application/json',
                },
            });
            const data = await response.json();
            if (!response.ok) {
                throw new common_1.BadRequestException(`PayPal capture error: ${data.message}`);
            }
            return data;
        }
        catch (error) {
            throw new common_1.BadRequestException(`Failed to capture PayPal order: ${error.message}`);
        }
    }
};
exports.PaypalService = PaypalService;
exports.PaypalService = PaypalService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [config_1.ConfigService])
], PaypalService);
//# sourceMappingURL=paypal.service.js.map